package de.juhu.distributor;

/**
 * Ein Leser ist fr das Einlesen einer Tabellenzeile verantwortlich. Er wird
 * ber die Methode {@link Distributor#addReader(Reader)} im aktuellen Verteiler
 * registriert und dann beim Einlesen einer Datei verwendet. Dabei wird die
 * Methode {@link #read(String[], int)} ausgefhrt, sobald die Zeile ber den
 * {@link #key Schlssel} des Lesers verfgt.
 * 
 * @version 1.0
 * @category Distribution
 * @author Juhu1705
 * @since 0.1.0
 *
 */
public abstract class Reader {

	/**
	 * Der Schlssel dieses Lesers, auf den dieser Leser beim Einlesen anspringen
	 * soll.
	 */
	String key;

	/**
	 * Erzeugt einen neuen Leser mit dem gewnschten Schlssel
	 * 
	 * @param key Der Schlssel des neuen Lesers.
	 */
	public Reader(String key) {
		this.key = key;
	}

	/**
	 * berprft, ob der gegebene Schlssel dem Schlssel dieses Lesers entspricht.
	 * 
	 * @param key Der Schlssel, der vergichen werden soll.
	 * @return Ob der Schlssel diesem Schlssel entspricht. Zum Vergleichen wird
	 *         die Methode {@link String#equalsIgnoreCase(String)} verwendet.
	 */
	public boolean isKey(String key) {
		return this.key.equalsIgnoreCase(key);
	}

	/**
	 * Liet die entsprechende Zeile ein.
	 * 
	 * @param line       Die Zeile die eingelesen werden soll.
	 * @param lineNumber Die Zeilennummer der Zeile im Programm.
	 * @implNote Die Zeile die eingelesen werden soll besitzt nun nicht mehr ihren
	 *           Schlssel, es beginnt direkt mit der ersten Argumentzelle dieser
	 *           Zeile.
	 */
	public abstract void read(String[] line, int lineNumber);

}
